<?php

use App\CategoryList;

include 'init.php';

$page_slug = 'custom-fields';
include 'check_auth.php';

?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <?php include 'includes/help_button.php' ?>

                    </div>
                    <div class="m-portlet__body" id="main-fields-wrapper">

                        <div class="m-portlet__body form-float-input">
                            <div class="m-form__group row">

                                <div class="col-lg-6">

                                    <div class="form-group select-group--float form-group--float form-group--icon">
                                        <label for="select-category"><?php _e('ADS_CATEGORY') ?> </label>
                                        <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                                        <select name="category" id="select-category" data-type="submit" class="form-control advanced-select">
                                            <option value="any" disabled selected style="display: none;"><?php _e('CHOOSE') ?></option>
                                            <?php
                                            $CategoryList = new CategoryList();
                                            $categories = $CategoryList->categories();
                                            /** @var App\Category $category */
                                            foreach ($categories as $category) {
                                                echo "<option value='{$category->ID}'>{$category->CATEGORY_NAME}</option>";
                                            }
                                            ?>
                                        </select>

                                        <div id="subcategory-placeholder" style="display:none; margin-top: 3px">
                                            <select name="subcategory" id="select-subcategory" class="form-control advanced-select">

                                            </select>
                                        </div>

                                        <div id="subsidiary-placeholder" style="display:none">
                                            <select name="subsidiary" id="select-subsidiary" class="form-control advanced-select">

                                            </select>
                                        </div>
                                        <p class="help-block" id="category-help-block"></p>
                                    </div>

                                    <div id="edit-custom-field-button" style="display: none">
                                        <a href="<?= adsRoute() ?>" class="btn btn-primary m-btn"> ویرایش </a>
                                    </div>
                                </div>




                            </div>
                        </div>

                    </div>
                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<script>
    var GLOBE__form_builder_url = "<?php echo categoriesRoute('custom-field-builder') ?>";
</script>
<?php include 'includes/scripts.php' ?>
<script src="assets/app/js/custom/pages/custom_fields.js"></script>
<script>
    initiateSelect2();
</script>

</body>
</html>

