<?php

use App\Category;
use App\CustomFields;
use App\SubCategory;

include 'init.php';

$page_slug = 'custom-fields';
include 'check_auth.php';

$Category = new Category();
$category = $Category->byId(input('cat_id'));

if (inputs()->not_empty('subcat_id')) {
    $Subcategory = new SubCategory();
    $subcategory = $Subcategory->byId(input('subcat_id'));
    $parent_subcategory = $subcategory->parentSubcategory();
}

$CustomField = new CustomFields();
$custom_fields = $CustomField->getFieldsForBuilder($category->ID, $subcategory->ID);

if (isAjax() && isPost() && input('action') === 'save-custom-fields') {
    include 'process/_save_custom_fields.php';
    return false;
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <meta charset="utf-8" />
    <title>ساخت فیلدهای اختصاصی</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <base href="<?= adminroot() ?>">
    <style></style>
    <link rel="stylesheet" href="vendors/toastr/build/toastr.min.css">
    <link rel="stylesheet" href="assets/vendors/form-builder/form-builder.css">
</head>

<body  style="background-color: black">


<div class="container">
    <div class="top-nav">
        <a href="<?= categoriesRoute('custom-fields') ?>">X</a>
    </div>

    <div class="breadcrumb">
        دسته بندی: &nbsp;&nbsp;
        <?php
        echo $category->CATEGORY_NAME;

        if (isset($parent_subcategory) && ! empty($parent_subcategory)) {
            echo " > " . $parent_subcategory->SUBCATEGORY_NAME;
        }
        if (isset($subcategory) && ! empty($subcategory)) {
            echo " > " . $subcategory->SUBCATEGORY_NAME;
        }
        ?>
    </div>

    <div id="fb-editor"></div>


<script>
    var form_data = '<?php echo $CustomField->toJson($custom_fields) ?>';
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js"></script>
<script src="vendors/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="../node_modules/formBuilder/dist/form-builder.min.js"></script>

<script src="assets/demo/custom/helpers.js"></script>
<script src="assets/vendors/form-builder/form-builder.js"></script>

</body>
</html>

