<?php

use App\Banner;

include 'init.php';

$page_slug = 'banners-slider';
include 'check_auth.php';

if (input('do') === 'add') {
    checkDemoMode();

    $Banner = new Banner();
    $Banner->createNew('SLIDER', 1300, 400);

    session()->success();
    redirect('refer');
}

if (input('do') === 'delete') {
    include('process/banners/_delete_banner.php');
    return false;
}

if (input('do') === 'update') {
    include('process/banners/_edit_banner.php');
    return false;
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/persianDatepicker/css/persianDatepicker-default.css"/>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <div class="row">

                    <div class="col-lg-12">
                        <?php session()->showAlert() ?>

                        <div class="row">
                            <div class="col-xl-3 col-lg-4">
                                <?php include 'includes/banners/slider/_sidebar.php' ?>
                            </div>
                            <div class="col-xl-9 col-lg-8">
                                <?php include 'includes/banners/slider/_banners.php' ?>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>

</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script>
    var GLOBE__category_ajax_url = 'process/ajax_calls.php';
    var GLOBE__filter_root = "<?php echo bannersRoute('slider') ?>";
    var banners_count = "<?php echo count($banners) ?>";
</script>

<script src="vendors/garand-sticky/jquery.sticky.js"></script>
<script src="vendors/persianDatepicker/js/persianDatepicker.min.js"></script>

<!-- Scripts -->
<script src="assets/app/js/custom/pages/category-custom-field.js"></script>
<script src="assets/app/js/custom/pages/banners.js"></script>

<script>
    initiateSelect2();
    initiateDatePickers();

    $("#sidebar-menu").sticky({topSpacing:150, widthFromWrapper: false});

    for (var i = 0; i <= banners_count; i++) {
        startImagePreview('#upload-banner-' + i);
    }
</script>


<script>

</script>

</body>
</html>

