<?php
use App\CategoryList;

include 'init.php';

$page_slug = 'banners-adv';
include 'check_auth.php';

if (input('do') === 'add') {
    include('process/banners/_create_adv_banner.php');
    return false;
}

if (input('do') === 'delete') {
    include('process/banners/_delete_banner.php');
    return false;
}

if (input('do') === 'update') {
    include('process/banners/_edit_banner.php');
    return false;
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/persianDatepicker/css/persianDatepicker-default.css"/>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <div class="row">

                    <div class="col-lg-12">
                        <?php session()->showAlert() ?>

                        <div class="row">
                            <div class="col-xl-3 col-lg-4">
                                <?php include 'includes/banners/adv/_sidebar.php' ?>
                            </div>
                            <div class="col-xl-9 col-lg-8">
                                <?php include 'includes/banners/adv/_banners.php' ?>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>



    <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModal" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">

                <form action="<?= bannersRoute('adv', 'create') ?>" method="post" class="form-float-input">

                    <div class="modal-header">
                        <h5 class="modal-title" id="addModalLongTitle"> افزودن بنر جدید </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="col-lg-12">

                            <div class="form-group btn-group--float btn-group-divided">
                                <label> عرض بنر  </label>
                                <div class="btn-group" data-toggle="buttons">
                                    <label class='btn '><input type="radio" name="WIDTH" value="300" >  300 پیکسل</label>
                                    <label class='btn'><input type="radio" name="WIDTH" value="400">  400 پیکسل</label>
                                    <label class='btn active'><input type="radio" name="WIDTH" value="600" checked>  600 پیکسل</label>
                                    <label class='btn'><input type="radio" name="WIDTH" value="1200">  1200 پیکسل</label>
                                    <label class='btn'><input type="radio" name="WIDTH" value="SIDEBAR">  سایدبار</label>
                                </div>
                            </div>

                            <div class="form-group form-group--float form-group--icon form-group--active">
                                <input type="text" id="HEIGHT" name="HEIGHT" class="form-control"  value="<?= input("HEIGHT") ?>">
                                <span class="input-icon-addon top-3"> <i class="fa fa-text-height"></i> </span>
                                <label for="HEIGHT">ارتفاع بنر</label>
                                <div class="help-block m-t-5">برحسب پیکسل -- مثال: 80</div>
                            </div>

                            <div class="form-group select-group--float form-group--float form-group--icon">
                                <label for="select-category"><?php _e('ADS_CATEGORY') ?> </label>
                                <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                                <select name="category" id="select-category" data-type="submit" data-action="find-subcategory-for-search-in-banners" class="form-control advanced-select">
                                    <option value="any" disabled selected style="display: none;"><?php _e('CHOOSE') ?></option>
                                    <?php
                                    $CategoryList = new CategoryList();
                                    $categories = $CategoryList->categories();
                                    /** @var App\Category $category */
                                    foreach ($categories as $category) {
                                        echo "<option value='{$category->ID}'>{$category->CATEGORY_NAME}</option>";
                                    }
                                    ?>
                                </select>

                                <div id="subcategory-placeholder" style="display:none; margin-top: 3px">
                                    <select name="subcategory" id="select-subcategory" data-action="find-subsidiary-for-search-in-banners" class="form-control advanced-select" title="frm_subcategory">

                                    </select>
                                </div>

                                <div id="subsidiary-placeholder" style="display:none">
                                    <select name="subsidiary" id="select-subsidiary" class="form-control advanced-select" title="frm_subsidiary">

                                    </select>
                                </div>
                                <p class="help-block" id="category-help-block"></p>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary m-btn m-btn--icon" data-dismiss="modal">
                            <span><i class="la la-remove"></i><span>انصراف</span></span>
                         </button>
                        <button type="submit" class="btn btn-success m-btn m-btn--icon">
                            <span><i class="la la-check"></i><span>ثبت</span></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script>
    var GLOBE__category_ajax_url = 'process/ajax_calls.php';
    var GLOBE__filter_root = "<?php echo bannersRoute('adv') ?>";
    var banners_count = "<?php echo count($banners) ?>";
</script>

<script src="vendors/garand-sticky/jquery.sticky.js"></script>
<script src="vendors/persianDatepicker/js/persianDatepicker.min.js"></script>

<!-- Scripts -->
<script src="assets/app/js/custom/pages/category-custom-field.js"></script>
<script src="assets/app/js/custom/pages/banners.js"></script>

<script>
    initiateSelect2();
    initiateDatePickers();

    $("#sidebar-menu").sticky({topSpacing:150, widthFromWrapper: false});

    for (var i = 0; i <= banners_count; i++) {
        startImagePreview('#upload-banner-' + i);
    }
</script>


<script>

</script>

</body>
</html>

