<?php

use App\Backup;

include 'init.php';

$page_slug = 'backup-list';
include 'check_auth.php';

checkDemoMode();

/**
 * Create a new Backup
 */
if (input('action') === "create") {
    $Backup = new Backup();

    if ($Backup->create()) {
        session()->success('عملیات پشتیبان گیری با موفقیت انجام شد');
        redirect(backupRoute());
    }

    session()->error();
    redirect(backupRoute());
}

/**
 * Delete Backup
 */
if (isPost() && token()->check() && input('action') === "delete") {
    $Backup = new Backup();
    $backup = $Backup->byId(input('id'));

    if ($backup) {
        $backup->destroy();
    }

    session()->success();
    redirect(backupRoute());
}

/**
 * Download Backup
 */
if (isPost() && token()->check() && input('action') === "download") {
    $Backup = new Backup();
    $backup = $Backup->byId(input('id'));

    if ($backup) {
        forceDownload($backup->fullPath());
        return false;
    }

    redirect(backupRoute());
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= backupRoute('create') ?>" class="btn btn-info m-btn m-btn--custom m-btn--icon portlet-action-button">
                                <span><i class="la la-plus"></i><span>ساخت پشتیبان جدید</span></span>
                            </a>

                            <?php include 'includes/help_button.php' ?>
                        </div>

                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <div class="table-responsive">
                                    <table class="table m-table table-bordered table-hover text-center big-header">
                                        <thead>
                                            <tr>
                                                <th>ردیف</th>
                                                <th>نام فایل</th>
                                                <th>تاریخ ساخت</th>
                                                <th>حجم</th>
                                                <th>عملیات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $Backup = new Backup();
                                            $backups = $Backup->all();

                                            if (! $backups) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($backups) :
                                                foreach ($backups as $backup) :
                                                    /** @var Backup $backup */
                                            ?>
                                            <tr>
                                                <td><?= $backup->id ?></td>
                                                <td class="foreign ltr"><?= $backup->name ?></td>
                                                <td><?= per_date($backup->created_at) ?></td>
                                                <td class="ltr"><?= getSize(filesize($backup->fullPath())) ?></td>
                                                <td class="m-datatable__cell">
                                                    <form class="form-inline" method="post" action="<?= $backup->downloadLink() ?>">
                                                        <?= csrf_field() ?>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="دانلود">
                                                            <i class="fa fa-cloud-download-alt"></i>
                                                        </button>
                                                    </form>

                                                    <form class="form-inline" method="post" action="<?= $backup->deleteLink() ?>" data-confirm-delete>
                                                        <?= csrf_field() ?>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>

                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

</body>
</html>

