<?php

use Admin\User;
use App\ReCaptcha;
use App\Validate;

include 'init.php';

checkUserCountry();
if (session()->exists('SESS_USER_ID')) {
    $User = new User();
    $User->logOut();
}

if (isPost() && token()->check() && isAjax()) {
    $ReCaptcha = new ReCaptcha();

    if (! $ReCaptcha->verify('login')) {
        return ajaxErrorResponse(['message' => $ReCaptcha->error()]);
    }

    $validate = new Validate();

    $rules = array(
        'username' => array(
            'name' => 'نام کاربری',
            'prefix' => 'وارد کردن',
            'required' => true,
        ),
        'password' => array(
            'name' => 'رمز عبور',
            'prefix' => 'وارد کردن',
            'required' => true
        )
    );

    $validation = $validate->check($_POST, $rules);

    if (! $validate->passed()) {
        return ajaxErrorResponse(['message' => $validation->errors()]);
    }

    $username = inputs()->get('username');
    $password = inputs()->get('password');

    $User = new User();
    $user = $User->findForLogin($username, $password);

    if (! $user || $user->isCommonUser()) {
        return ajaxErrorResponse([
            'message' => _e('INCORRECT_USERNAME_AND_PASSWORD', true)]
        );
    }

    if ($user && ! $user->isCommonUser()) {
        $user->login();
        if (inputs()->is_set('remember')) {
            $user->remember();
        }

        return ajaxSuccessResponse([
                'message' => _e('REDIRECTING', true),
                'callback_url' => adminroot()
        ]);
    }
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="m--skin- m-header--fixed m-header--fixed-mobile m-aside-left--enabled m-aside-left--skin-dark m-aside-left--fixed m-aside-left--offcanvas m-footer--push m-aside--offcanvas-default">


<div class="m-grid m-grid--hor m-grid--root m-page">
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--hor m-login m-login--signin m-login--2 m-login-2--skin-3" id="m_login" style="background-image: url(assets/app/media/img//bg/bg-2.jpg);">
        <div class="m-grid__item m-grid__item--fluid	m-login__wrapper">
            <div class="m-login__container">
                <div class="m-login__logo">
                    <a href="#">
                        <img src="../images/logo.png">
                    </a>
                </div>
                <div class="m-login__signin">
                    <div class="m-login__head">
                        <h3 class="m-login__title"><?php _e('SIGN_IN_TO_ADMIN') ?></h3>
                    </div>
                    <?php if (isDemoMode()) : ?>
                        <div class='alert alert-focus' id="demo-mode-login-info">
                            مشخصات ورود به مدیریت در حالت دمو : <br/><br/>
                            نام کاربری : test <br/> رمز عبور : test
                        </div>
                    <?php endif; ?>

                    <?php session()->showAlert() ?>

                    <form class="m-login__form m-form" action="">

                        <?= csrf_field() ?>

                        <div class="form-group m-form__group">
                            <input class="form-control m-input" type="text" placeholder="<?= _e('USERNAME') ?>" name="username" autocomplete="off">
                        </div>
                        <div class="form-group m-form__group">
                            <input class="form-control m-input" type="password" placeholder="<?= _e('PASSWORD') ?>" name="password">
                        </div>

                        <div class="row m-login__form-sub">
                            <div class="col m--align-left m-login__form-left">
                                <label class="m-checkbox  m-checkbox--light">
                                    <input type="checkbox" name="remember"> <?php _e('REMEMBER_ME') ?>
                                    <span></span>
                                </label>
                            </div>
                        </div>

                        <div id="recpatcha-part" style="margin-top: 30px">
                            <?php if (isImageCaptcha()) : ?>
                                <div class="image-captcha text-center">
                                    <img src="<?= captcha()->show('login') ?>" id="login_captcha" alt="login captcha" class="image-captcha" style="margin-bottom: 15px;">
                                    <div class="captcha-update-handler">
                                        <i class="fa fa-redo" data-click-updates-captcha data-namespace="login" data-target="#login_captcha"></i>
                                    </div>
                                </div>

                                <div class="form-group m-form__group">
                                    <input class="form-control m-input m-login__form-input--last captcha-input" type="text" placeholder="<?php _e('CAPTCHA_CODE') ?>" name="captcha">
                                </div>
                            <?php endif; ?>

                            <?php if (isRecaptcha()) : ?>
                                <div class="g-recaptcha" id="login-recaptcha" data-sitekey="<?= setting('RECAPTCHA_SITE_KEY') ?>"></div>
                                <div class="mini-next-line"></div>
                            <?php endif; ?>
                        </div>


                        
                        <div class="m-login__form-action">
                            <button id="m_login_signin_submit" class="btn btn-focus m-btn m-btn--pill m-btn--custom m-btn--air  m-login__btn"><?php _e('LOGIN') ?></button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>


<?php include 'includes/scripts.php' ?>
<script src='https://www.google.com/recaptcha/api.js?hl=<?= lang() ?>'></script>
<script src="vendors/jquery-form/dist/jquery.form.min.js" type="text/javascript"></script>
<script src="vendors/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="vendors/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="vendors/js/framework/components/plugins/forms/jquery-validation.init.js" type="text/javascript"></script>


<script>
    var ajax_captcha_route = "<?php echo ajaxRoute('captcha') ?>";
</script>
<script src="assets/snippets/custom/pages/user/login.js" type="text/javascript"></script>
</body>
</html>

