/*
 * handles the ajax request for locations multi level select box
 */
(function(){

    $('*[data-location-selector]').on('change', function(e) {
        e.preventDefault();

        var $this = $(this);
        var parent_id = $this.val();
        var location_type = $this.attr('data-target-type');
        var child_selector = $($this.attr('data-child-selector'));
        var child_status = $this.attr('data-child-status')  || 'visible';
        var erase_field = $this.attr('data-child-erase');
        var default_html = "<option value='0' disabled selected style='display: none;'>انتخاب کنید</option>";

        if (child_status === 'hidden') {
            var default_option_name = child_selector.find('option:disabled').text();
            var default_html = "<option value='any' disabled selected style='display: none;'>" + default_option_name + "</option>";
        }

        child_selector.html(default_html);
        if(erase_field) {
            var current_erase_field = $(erase_field);
            current_erase_field.html(default_html);
            if (child_status === 'hidden') {
                current_erase_field.closest('.select-parent').hide();
                current_erase_field.trigger('change');
            }
        }

        if (! parent_id || parent_id == 0 || parent_id == 'any') {
            return false;
        }

        if(child_status === 'hidden' && parent_id) {
            var loading = $this.siblings('.select-loading').first();
            loading.show();
        }

        $.ajax({
            url : ajax_locations_route,
            dataType : 'json',
            type : 'get',
            data : {
                'parent_id' : parent_id,
                'location_type' : location_type
            },

            success : function(response){
                if (response.status && response.locations.length > 0) {
                    var locations = response.locations;
                    var html = default_html;
                    var location_name = null;
                    var location_id = null;

                    $.each(locations, function(id, location) {
                        if(location_type === 'city') {
                            location_name = location.CITY_NAME;
                            location_id = location.ID;
                        }
                        if(location_type === 'zone') {
                            location_name = location.ZONE_NAME;
                            location_id = location.ZONE_ID;
                        }

                        html += "<option value='" + location_id + "' data-latitude='" + location.latitude + "' data-longitude='" + location.longitude + "'> " + location_name + "</option>";
                    });

                    child_selector.removeAttr('disabled').html(html);
                    if(child_status === 'hidden') {
                        loading.hide();
                        child_selector.trigger('change');
                        child_selector.closest('.select-parent').show();
                    }
                } else {
                    if(child_status === 'hidden') {
                        loading.hide();
                    }
                    child_selector.attr('disabled', 'disabled').html(default_html);
                }
            }
        });
    });
})();


/*
 * Initiates the location picker plugin
 *
 * @map_selector_id : id of the dom that show the map
 * @options : object of options containing : { default_lng : default_lng, default_lat : default_lat, radius: radius, zoom: zoom, latitudeInput : latitudeInput, longitudeInput: longitudeInput, locationNameInput: locationNameInput }
 */
function showLocationPicker(map_selector_id, options)
{
    options.default_lng = options.default_lng || 51.388973599999986;
    options.default_lat = options.default_lat || 35.6891975;

    var map = $("#" + map_selector_id).locationpicker({
        location: {
            longitude: options.default_lng,
            latitude: options.default_lat
        },
        radius: options.radius || 0,
        zoom: options.zoom || 15,
        inputBinding: {
            latitudeInput: options.latitudeInput || $("#frm_latitude"),
            longitudeInput: options.longitudeInput ||  $("#frm_longitude"),
            locationNameInput: options.locationNameInput ||  $("#locationName")
        },
        enableAutocomplete: !0
    });
}

$('*[data-changes-map]').on('change', function(e) {
    e.preventDefault();

    var selected_option = $(this).find(':selected');
    var latitude = selected_option.attr('data-latitude');
    var longitude = selected_option.attr('data-longitude');

    if (! latitude || ! longitude || latitude == 'null' || longitude == 'null') {
        return false;
    }

    var map_selector_id = $(this).attr('data-map-selector-id');
    updateLocationPicker(map_selector_id, latitude, longitude);
});

function updateLocationPicker(map_selector_id, latitude, longitude) {
    $("#" + map_selector_id).locationpicker("location", {latitude: latitude, longitude: longitude});
}
