const app = Vue.createApp({
    components: {
        draggable: window['vuedraggable']
    },
    data() {
        return {
            widgets: [],
            active_widgets: [],
            isSelectingWidget: false,
            isLoading: false
        }
    },
    mounted() {
        this.fetchWidgets();
    },
    methods: {
        showWidgetsList() {
            this.isSelectingWidget = true;
        },
        hideWidgetsList() {
            this.isSelectingWidget = false;
        },
        fetchWidgets() {
            axios.get(GLOBE__site_url + 'adm-kodes/api/widgets', {
                params: {
                    page_id: Globe__page_id
                }
            })
                .then(({data}) => {
                    this.widgets = data.widgets;
                    this.active_widgets = data.active_widgets
                });
        },
        addToActiveWidgets(widget) {
            let wgt = {...widget}
            wgt.UUID = Date.now() - (Math.random() * 100);
            wgt.open = true;

            this.active_widgets.push(wgt);
            this.isSelectingWidget = false;
        },
        toggleWidget(widget) {
            widget.open = !widget.open;
        },
        removeWidget(widget) {
            if (!confirm("آیا از حذف این ابزارک اطمینان دارید؟")) {
                return false;
            }

            let index = this.active_widgets.findIndex((item) => item.UUID === widget.UUID);

            this.active_widgets.splice(index, 1);
        },
        store() {
            this.isLoading = true;
            axios.post(GLOBE__site_url + 'adm-kodes/api/widgets/store', {
                page_id: Globe__page_id,
                widgets: this.active_widgets
            }).then(({data}) => {
                this.isLoading = false;
                console.log('hooora');
            });
        }
    }
});

app.mount('#widget-builder');