const support_dates = Vue.createApp({
    data() {
        return {
            isLoading: false,
            startDate: vue__support_dates.start_date,
            endDate: vue__support_dates.end_date,
            isExpired: !!vue__support_dates.is_expired,
            daysPassed: vue__support_dates.days_passed,
            extensionLink: vue__support_dates.extension_link,
            supportLink: vue__support_dates.support_link,
            setByAdmin: false,
            fetchResult: null,
            error: null
        }
    },
    mounted() {

    },
    computed: {
        shouldShowNotification: function() {
            return this.isExpired ||  this.daysPassed < 7
        },
        alertClass: function() {
            return this.isExpired ? 'alert-danger' : 'alert-warning';
        },
        daysPassedText: function() {
            return this.isExpired ? `${this.daysPassed} روز گذشته` : `${this.daysPassed} روز مانده`;
        },
        alertText: function() {
            return this.isExpired ? 'پشتیبانی اسکریپت نیازمندی های کدیزاین به اتمام رسیده است' : 'پشتیبانی اسکریپت نیازمندی های کدیزاین رو به اتمام است'
        }
    }
    ,
    methods: {
        refresh() {
            this.isLoading = true;

            axios.post(`https://support.kodesign.ir/api/support/customer/dates`, {
                purchase_code: Globe__purchase_code,
                domain_name: Globe__site_domain
            })
            .then(
                ({data}) => {
                    this.error = null;
                    this.startDate = data.start_date_jalali;
                    this.endDate = data.end_date_jalali;
                    this.isExpired = data.is_expired;
                    this.daysPassed = data.days_passed;
                    this.fetchResult = data;
                    this.extensionLink = data.extension_link;
                    this.supportLink = data.support_link;
                    this.setByAdmin = data.set_by_admin;
                    
                    this.isLoading = false;

                    this.updateSettings();
                },
                ({response : error}) => {
                    this.isLoading = false;
                    this.error = error.data;
                }
            );
        },
        updateSettings() {
            axios.post(Globe__update_setting_url, {
                start_date: this.fetchResult.start_date,
                end_date: this.fetchResult.end_date,
            })
        }
    }
});

support_dates.mount('#dates');