const support_callouts = Vue.createApp({
    data() {
        return {
            callouts: [],
            unreadCallouts: [],
            isLoading: false,
            error: null,
            showModal: false,
            currentCallout: null
        }
    },
    mounted() {
        this.fetchCallouts();
    },
    methods: {
        fetchCallouts() {
            this.isLoading = true;
            axios.post(`https://support.kodesign.ir/api/support/customer/callouts`, {
                purchase_code: Globe__purchase_code,
                domain_name: Globe__site_domain
            })
            .then(
                ({data}) => {
                    this.error = null;
                    this.callouts = data.callouts;
                    this.unreadCallouts = data.unread_callouts;
                    this.isLoading = false;
                    this.showLatestUnreadCallout();
                },
                ({response : error}) => {
                    console.log({error});
                    this.isLoading = false;
                    this.error = error.data;
                }
            );
        },
        openCallout(callout) {
            this.currentCallout = callout;
            this.markCalloutAsRead();
            this.showModal = true;
        },
        closeModal() {
            this.showModal = false;
            this.currentCallout = null;
        },
        bannerClicked() {
            if (! this.currentCallout.link) return false;

            window.open(this.currentCallout.link, '_blank').focus();
        },
        markCalloutAsRead() {
            axios.post(`${GLOBE__site_url}/adm-kodes/ajax/read-callout`, {
                callout_id: this.currentCallout.id
            }).then(({data}) => {
                if (data.status && data.just_read) {
                    this.markCalloutAsReadOnServer();
                }
            })
        },
        markCalloutAsReadOnServer() {
            axios.post(`https://support.kodesign.ir/api/support/customer/callouts/${this.currentCallout.id}/read`, {
                purchase_code: Globe__purchase_code,
                domain_name: Globe__site_domain
            })
        },
        showLatestUnreadCallout() {
            if (! this.unreadCallouts[0]) return false;

            this.currentCallout = this.unreadCallouts[0];
            this.markCalloutAsRead();
            this.showModal = true;
        }
    }
});

support_callouts.mount('#callouts');