const support_activities = Vue.createApp({
    data() {
        return {
            activities: [],
            isLoading: false,
            error: null
        }
    },
    mounted() {
        this.fetchActivities();
    },
    methods: {
        fetchActivities() {
            this.isLoading = true;
            axios.post(`https://support.kodesign.ir/api/support/customer/activities`, {
                purchase_code: Globe__purchase_code,
                domain_name: Globe__site_domain
            })
            .then(
                ({data}) => {
                    this.error = null;
                    this.activities = data;
                    this.isLoading = false;
                },
                ({response : error}) => {
                    console.log({error});
                    this.isLoading = false;
                    this.error = error.data;
                }
            );


        },
        activityIcon(activity_type) {
            if (activity_type === 'buy') {
                return 'flaticon-cart';
            }
            if (activity_type === 'update') {
                return 'flaticon-upload-1';
            }
        }
    }
});

support_activities.mount('#activities');