<?php

use App\Category;
use App\PolicyReport;

include 'init.php';

$page_slug = 'ads-report';
include 'check_auth.php';

if (input('action') === 'delete' && token()->check()) {
    checkDemoMode();
    $PolicyReport = new PolicyReport();
    $report = $PolicyReport->byId(input('id'));

    if ($report) {
        $report->delete();
    }

    session()->success();
    redirect('refer');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <?php include 'includes/help_button.php' ?>
                        </div>

                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <div class="table-responsive">
                                    <table class="table m-table table-bordered table-hover text-center big-header">
                                        <thead>
                                            <tr>
                                                <th>شناسه</th>
                                                <th>عنوان آگهی</th>
                                                <th>علت گزارش</th>
                                                <th>تاریخ ثبت</th>
                                                <th>ارسال کننده گزارش</th>
                                                <th>IP</th>
                                                <th>عملیات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $PolicyReport = new PolicyReport();
                                            $reports = $PolicyReport->all();

                                            if (! $reports) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($reports) :
                                                $reports = $PolicyReport->eagerLoad('ads', $reports);
                                                $reports = $PolicyReport->eagerLoad('user', $reports);

                                                foreach ($reports as $report) :
                                                    /** @var PolicyReport $report */
                                            ?>
                                            <tr>
                                                <td><?= $report->ID ?></td>
                                                <td><a href="<?= $report->ads()->shortLink() ?>" target="_blank"><?= $report->ads()->ADS_TITLE ?></a></td>
                                                <td><?= $report->reasonToReport() ?></td>
                                                <td><?= per_date($report->DATE_CREATED)?></td>
                                                <td>
                                                    <?php if (! empty($report->user()->publicName())) : ?>
                                                        <a href="<?= $report->user()->profileLink() ?>" target="_blank"><?= $report->user()->publicName() ?></a>
                                                    <?php else : ?>
                                                        کاربر مهمان
                                                    <?php endif; ?>
                                                </td>
                                                <td><a href="<?= ipLink($report->IP); ?>" target="_blank"><?= $report->IP ?></a></td>
                                                <td class="m-datatable__cell">
                                                    <a href="#view-modal-<?= $report->ID ?>" role="button" data-toggle="modal" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="مشاهده گزارش کامل ">
                                                        <i class="la la-eye"></i>
                                                    </a>

                                                    <form class="form-inline" method="post" action="<?= $report->deleteLink() ?>" data-confirm-delete>
                                                        <?= csrf_field() ?>

                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>

                                            <div class="modal fade" id="view-modal-<?= $report->ID ?>" tabindex="-1" role="dialog" aria-labelledby="edit-modal" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="addModalLongTitle">مشاهده گزارش </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>

                                                        <div class="modal-body">
                                                            <div class="col-lg-12">
                                                                <p class="m-badge m-badge--square m-badge--info"> عنوان آگهی :<?= $report->ads()->ADS_TITLE ?> </p>
                                                                <p style="font-size: 16px; margin-top: 20px;"> <?= $report->reasonToReport() ?> </p>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary m-btn m-btn--icon" data-dismiss="modal">
                                                                <span><i class="la la-remove"></i><span>بستن</span></span>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>

                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

</body>
</html>

