<?php

use Admin\Ads;
use Admin\Pagination;
use App\Category;

use App\Plan;

include 'init.php';

$page_slug = 'ads-list';
include 'check_auth.php';

if (isPost() && token()->check()) {
    include ('process/ads/_bulk_actions.php');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="m-alert m-alert--icon m-alert--air m-alert--square alert alert-dismissible m--margin-bottom-30" role="alert">
                    <div class="m-alert__icon">
                        <i class="flaticon-exclamation m--font-primary"></i>
                    </div>
                    <div class="m-alert__text">
                        در صورتی که هیچ فیلتری اعمال نشده باشد صرفا <strong><?= setting('ADMIN_PANEL_NOT_FILTERED_ADS_COUNT') ?></strong> مورد آخر
                        <?php if (! isDemoMode()) : ?>
                            (که طی یک ماه اخیر ثبت شده باشند)
                        <?php endif; ?>
                        نمایش داده خواهد شد. برای مشاهده نتایج بیشتر از بخش فیلتر استفاده نمایید
                    </div>
                </div>

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= adsRoute('create') ?>" class="btn btn-info m-btn m-btn--custom m-btn--icon m-btn--air portlet-action-button">
                                <span><i class="la la-plus"></i><span>افزودن آگهی جدید</span></span>
                            </a>
                            <ul class="m-portlet__nav">
                                <li class="m-portlet__nav-item">
                                    <div class="m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                                        <a href="#" class="m-portlet__nav-link btn btn-lg btn-secondary  m-btn m-btn--icon m-btn--icon-only m-btn--pill  m-dropdown__toggle">
                                            <i class="la la-ellipsis-h m--font-brand"></i>
                                        </a>
                                        <div class="m-dropdown__wrapper">
                                            <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust"></span>
                                            <div class="m-dropdown__inner">
                                                <div class="m-dropdown__body">
                                                    <div class="m-dropdown__content">


                                                        <form action="" method="post" class="nav-menu-form">
                                                            <?= csrf_field() ?>

                                                            <input type="hidden" name="action">

                                                            <ul class="m-nav">
                                                                <li class="m-nav__section m-nav__section--first">
                                                                    <span class="m-nav__section-text">عملیات ها</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="accept">
                                                                        <i class="m-nav__link-icon fa fa-check"></i>
                                                                        <span class="m-nav__link-text">تایید</span>
                                                                    </a>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="paid">
                                                                        <i class="m-nav__link-icon fa fa-sync-alt"></i>
                                                                        <span class="m-nav__link-text">پرداخت شده</span>
                                                                    </a>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="reject">
                                                                        <i class="m-nav__link-icon fa fa-pause"></i>
                                                                        <span class="m-nav__link-text">رد کردن</span>
                                                                    </a>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="delete" data-irreversible="true">
                                                                        <i class="m-nav__link-icon fa fa-times"></i>
                                                                        <span class="m-nav__link-text">حذف</span>
                                                                    </a>
                                                                </li>

                                                                <?php if ($current_page->hasHelp()) : ?>
                                                                <li class="m-nav__section">
                                                                    <span class="m-nav__section-text">لینک های مفید</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-toggle="modal" data-target="#helpModal">
                                                                        <i class="m-nav__link-icon fa fa-question-circle"></i>
                                                                        <span class="m-nav__link-text">راهنما</span>
                                                                    </a>
                                                                </li>
                                                                <?php endif; ?>

                                                                <li class="m-nav__separator m-nav__separator--fit m--hide"></li>

                                                                <li class="m-nav__item m--hide">
                                                                    <a href="#" class="btn btn-outline-danger m-btn m-btn--pill m-btn--wide btn-sm">Submit</a>
                                                                </li>
                                                            </ul>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <?php include('includes/ads_list/_filter.php') ?>

                                <div class="table-responsive"  style="margin-top: 50px">
                                    <table class="table table-bordered m-table table-hover">
                                        <thead>
                                        <tr>
                                            <th>
                                                <label class="m-checkbox m-checkbox--air m-checkbox--solid">
                                                    <input type="checkbox" data-click-checks-all-rows>
                                                    <span></span>
                                                </label>
                                            </th>
                                            <th>شناسه</th>
                                            <th>عنوان آگهی</th>
                                            <th>تاریخ ثبت</th>
                                            <th>آخرین ویرایش</th>
                                            <?php if (setting('SHOW_ADS_VIEWS') === "NO") : ?>
                                                <th class="hidden-500">بازدیدها</th>
                                            <?php endif; ?>
                                            <th> نوع آگهی</th>
                                            <th> وضعیت</th>
                                            <th> IP</th>
                                            <th> بازدید</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $id = $title = $category = $type = $status = $time = $user = $sort = null;
                                            extract($_GET);

                                            $limited_days_for_not_filtered = 30;
//                                            $limited_days_for_not_filtered = 0;
                                            if (isDemoMode()) {
                                                $limited_days_for_not_filtered = 0;
                                            }

                                            $is_filtered = Ads::is_filtered($id, $title, $category, $type, $status, $time, $user, $sort);

                                            if ($is_filtered) {
                                                $count = Ads::countFilteredAds($id, $title, $category, $type, $status, $time, $user, $sort);
                                                $sql = Ads::sqlForFilteredAds(false, true, $id, $title, $category, $type, $status, $time, $user, $sort);
                                            } else {
                                                $count = 0;
                                                $sql = Ads::sqlForFilteredAds(false, false, $id, $title, $category, $type, $status, $time, $user, $sort, $limited_days_for_not_filtered);
                                            }

                                            $page = inputs()->not_empty('page') ? (int) input('page') : 1;
                                            $per_page = 15;
                                            $total_count = $count;

                                            $pagination = new Pagination($page, $per_page, $total_count);
                                            $pageParameters = array('id' => $id, 'title' => $title, 'category' => $category, 'type' => $type, 'status' => $status, 'time' => $time, 'user' => $user, 'sort' => $sort);
                                            $pagination->main_page = $pagination->makePageUrl(adsRoute(), $pageParameters);

                                            if ($is_filtered) {
                                                $pagination->sql = $sql;
                                                $sql = $pagination->correct_sql();
                                            }

                                            $adss = Ads::find_by_sql($sql);

                                            if (! $adss) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($adss) :
                                                foreach ($adss as $ads) :

                                                    /** @var Ads $ads */
                                                    $ads->checkStatus();
                                            ?>
                                            <tr>
                                                <th scope="row">
                                                    <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $ads->ADS_ID ?>"><span></span></label>
                                                </th>
                                                <td><?= $ads->ADS_ID ?></td>
                                                <td><a href='<?= $ads->viewLink() ?>' target='_blank'><?= limit_word($ads->ADS_TITLE, 6) ?></a></td>
                                                <td><?= ($ads->DATE_CREATED > 0 && $ads->DATE_CREATED !== NULL) ? miladiToShamsiAdmin($ads->DATE_CREATED, "Y/m/d") : null ?></td>
                                                <td><?= ($ads->DATE_UPDATED > 0 && $ads->DATE_UPDATED !== NULL) ? miladiToShamsiAdmin($ads->DATE_UPDATED, "Y/m/d") : miladiToShamsiAdmin($ads->DATE_UPDATED, "Y/m/d") ?></td>
                                                <?php if (setting('SHOW_ADS_VIEWS') === "NO") : ?>
                                                    <td class="hidden-500"><?= $ads->VIEWS ?></td>
                                                <?php endif; ?>
                                                <td class="ltr star-rate-field"><?= $ads->star_rate() ?></td>
                                                <td><?= $ads->ads_general_status() ?> <?= ($ads->isEdited()) ? "<span class='m-badge m-badge--brand m-badge--wide'> ویرایش شده </span>" : false ?></td>
                                                <td><a href="<?= ipLink($ads->IP) ?>" target='blank'><?= $ads->IP ?></a></td>
                                                <td class="ltr"><?= number_format($ads->VIEWS) ?></td>
                                                <td class="m-datatable__cell">
                                                    <?php if (! $ads->is_text()) : ?>
                                                        <a class="dropdown">
                                                            <a href="#" class="btn m-btn m-btn--hover-success m-btn--icon m-btn--icon-only m-btn--pill" data-toggle="dropdown">
                                                                <i class="la la-ellipsis-h"></i>
                                                            </a>
                                                            <div class="dropdown-menu dropdown-menu-right dropdown-fix">
                                                                <a class="dropdown-item" href="<?= adsRoute('mutate', $ads->ADS_ID) ?>"><i class="la la-superscript"></i>جهش</a>
                                                                <a class="dropdown-item" href="<?= $ads->viewLink() ?>" target="_blank"><i class="la la-eye"></i>مشاهده</a>
                                                            </div>

                                                        </a>
                                                    <?php endif; ?>

                                                    <a href="<?= adsRoute('edit', $ads->ADS_ID) ?>" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="ویرایش ">
                                                        <i class="la la-edit"></i>
                                                    </a>
                                                    <form class="form-inline" action="<?= $ads->deleteLink() ?>" data-confirm-delete>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف ">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>

                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>

                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>
                                    <?php if ($is_filtered) : ?>
                                        <div class="dataTables_wrapper">
                                            <div class="dataTables_paginate paging_full_numbers">
                                                <ul class="pagination">
                                                    <?php $pagination->show_pagination() ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>
    $('.selectpicker').selectpicker();
</script>
</body>
</html>

