<?php

use Admin\Ads;
use App\CustomFields;
use App\Tag;

include 'init.php';

$page_slug = 'ads-edit';
include 'check_auth.php';

$page__has_maps = true;

$Ads = new Ads();
$Tags = new Tag();

$ads = $Ads->ads_by_id(input('id'), false);

if (! $ads) {
    abort();
}

if ($ads->PARENT != 0) {
    $parent = $ads->findSubcategoryParent();
}

$CustomFields = new CustomFields();
$custom_fields = $CustomFields->getFieldsForAds($ads);

$user = $User->findById($ads->USER_ID);

$ads_images = $ads->images('thumb', true, false);
$ads_images_count = ($ads_images) ? count($ads_images) : 0;


$start_images_count = $ads_images_count + 3;

if ($start_images_count < 6) {
    $start_images_count = 6;
}

for ($i = 1; $i <= $start_images_count; $i++) {
    $preuploaded_images_names[] = [
        'id' => $i,
        'name' => removeExtension(basename(removeSizeFromImageName($ads_images[$i - 1])))
    ];
}

if (isPost() && token()->check()) {
    checkDemoMode();

    include('process/pr_edit_estate.php');
}

$top_menus = [
    [
        'icon' => 'flaticon-eye',
        'title' => 'مشاهده آگهی',
        'link' => $ads->viewLink(),
    ]
]

?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/persianDatepicker/css/persianDatepicker-default.css"/>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= adsRoute() ?>"
                                               class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                بازگشت
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item"
                                                        class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                    <i class="la la-check"></i>
                                                    ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-7">
                                    <?php include('includes/edit_ads/_main_fields.php') ?>
                                </div>
                                <div class="col-lg-5">
                                    <?php
                                    include('includes/edit_ads/_status_widgets.php');

                                    include('includes/edit_ads/_upload_images.php');

                                    if (setting('SUBMIT__ENABLE_LOCATION_PICKER') === 'YES') {
                                        include('includes/add_ads/_location_picker.php');
                                    }

                                    include('includes/edit_ads/_votes.php');
                                    ?>
                                </div>
                            </div>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<?php include 'includes/_validate_js_variables.php' ?>

<!-- plugins -->

<script type="text/javascript" src="vendors/ckeditor/ckeditor.js"></script>
<script type="text/javascript" src="../public/lib/simple-ajax-uploader/SimpleAjaxUploader.min.js"></script>

<script>
    var images_count = "<?php echo $start_images_count ?>";
    var preuploaded_images_count = "<?php echo $ads_images_count; ?>";
    var preuploaded_images_names = <?php echo json_encode($preuploaded_images_names); ?>;

    var ads_id = "<?php echo $ads->ADS_ID ?>";

    var long = "<?php echo $ads->LONGITUDE ?>";
    var lat = "<?php echo $ads->LATITUDE ?>";
    long = long || "<?php echo setting('DEFAULT_LONG') ?>";
    lat = lat || "<?php echo setting('DEFAULT_LAT') ?>";
</script>

<!-- scripts -->
<script src="assets/app/js/custom/pages/category-custom-field.js"></script>
<script src="assets/app/js/custom/pages/upload_edit.js"></script>
<script src="assets/app/js/custom/pages/validate_ads.js"></script>
<script src="vendors/persianDatepicker/js/persianDatepicker.min.js"></script>

<script src="assets/demo/custom/locations.min.js"></script>
<script src="assets/demo/custom/remote-select.js"></script>
<script src="vendors/ckeditor/ckeditor.js"></script>

<script>

    startCKEditor('frm_description');
    startCKEditor('REJECTION_CAUSE');
    initiateSelect2();
    initiateSelect2Tags();
    initiateDatePickers();

    $('.selectpicker').selectpicker();


    price_field_remover("price");
    price_field_remover("mortgage");
    price_field_remover("rent");

    $("#calculate_end_time").click(function () {
        var adsId = ads_id;
        var planId = $("#frm_plan_type").val();
        var fromDate = $("#frm_from_date").val();

        $.ajax({
            url: "process/ajax_calls.php",
            type: "post",
            data: {planId: planId, fromDate: fromDate, adsId: adsId},
            dataType: 'json',
            success: function (response) {
                if (response.status) {
                    swal({
                        title: 'تاریخ انقضای آگهی : ',
                        text: response.message,
                        type: 'error',
                        confirmButtonText: 'متوجه شدم',
                    });
                }
            }
        })
    });

    if (! $("#show_map").is(':checked')) {
        $("#map-place").slideUp();
    }

    $("#frm_status").on('change', function () {
        var text_area = $("#rejection_cause_wrapper");

        if ($(this).val() == 4) {
            text_area.slideDown();
        } else {
            text_area.slideUp();
        }
    });

    if (isGoogleMaps()) {
        initializeGoogleLocationPicker(
            'location_picker',
            lat,
            long,
            14
        );
    }

    if (isLeafletMaps() || isNeshanMaps()) {
        initialiseAdvancedLeafletLocationPicker(
            'location_picker',
            lat,
            long,
            14,
            true
        );
    }

</script>
</body>
</html>

