<?php

use Admin\Ads;

include 'init.php';

$page_slug = 'ads-create';
include 'check_auth.php';

$Ads = new Ads();
$start_images_count = 6;
$page__has_maps = true;

if(isPost() && token()->check()) {
    checkDemoMode();

    include('process/pr_add_estate.php');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <?= csrf_field() ?>

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile" >
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= adsRoute() ?>" class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                انصراف
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item" class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                        <i class="la la-check"></i>
                                                        ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-7">
                                    <?php include('includes/add_ads/_main_fields.php') ?>
                                </div>
                                <div class="col-lg-5">
                                    <?php
                                    include('includes/add_ads/_status_widgets.php');

                                    include('includes/add_ads/_upload_images.php');

                                    if (setting('SUBMIT__ENABLE_LOCATION_PICKER') === 'YES') {
                                        include('includes/add_ads/_location_picker.php');
                                    }
                                    ?>
                                </div>
                            </div>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<?php include 'includes/_validate_js_variables.php' ?>

<!-- plugins -->

<script type="text/javascript" src="vendors/ckeditor/ckeditor.js"></script>
<script type="text/javascript" src="../public/lib/simple-ajax-uploader/SimpleAjaxUploader.min.js"></script>

<script>
    var images_count = "<?php echo $start_images_count ?>";
    var long = "<?php echo setting('DEFAULT_LONG') ?>";
    var lat  = "<?php echo setting('DEFAULT_LAT') ?>";
</script>

<!-- scripts -->
<script src="assets/app/js/custom/pages/category-custom-field.js"></script>
<script src="assets/app/js/custom/pages/upload.js"></script>
<script src="assets/app/js/custom/pages/validate_ads.js"></script>

<script src="assets/demo/custom/locations.min.js"></script>
<script src="assets/demo/custom/remote-select.js"></script>
<script src="vendors/ckeditor/ckeditor.js"></script>

<script>

    startCKEditor('frm_description');
    initiateSelect2();
    initiateSelect2Tags();

    if (isGoogleMaps()) {
        initializeGoogleLocationPicker(
            'location_picker',
            "<?php echo setting('DEFAULT_LAT') ?>",
            "<?php echo setting('DEFAULT_LONG') ?>",
            14
        );
    }

    if (isLeafletMaps() || isNeshanMaps()) {
        initialiseAdvancedLeafletLocationPicker(
            "location_picker",
            "<?php echo setting('DEFAULT_LAT') ?>",
            "<?php echo setting('DEFAULT_LONG') ?>",
            12
        );
    }

</script>
</body>
</html>

