<?php

use App\User;

include 'init.php';

$no_index = true;

$page_slug = 'external-actions';
include 'includes/core/check_auth.php';

$allowed_actions = ['refer'];
$action = input('action');

if (!in_array($action, $allowed_actions)) {
    abort();
}

if ($action === 'refer' && inputs()->not_empty('id')) {
    $user = (new User())->findByUuid(input('id'));

    if ($user) {
        cookie()->put('COOK_KODESIGN_REFERAL', $user->uuid, 24 * 3600);
    }

    if ($loggedUser && $user->USER_ID == currentUser()->USER_ID) {
        cookie()->delete('COOK_KODESIGN_REFERAL');
    }
}

redirect('root');
