<?php
include 'init.php';

$no_index = true;

$page_types = [
    'account-dashboard',
    'account-my-listing',
    'account-favourites',
    'account-comments',
    'account-profile-edit',
    'account-profile-avatar',
    'account-profile-change-password',
    'account-profile-submit-email',
    'account-profile-submit-mobile',
    'account-payments-history',
    'account-payments-invoice',
    'account-affiliate-banners',
    'account-affiliate-history',
    'account-messages-email',
    'account-messages-sms',
    'account-item-edit',
    'account-item-change-plan',
    'account-item-extend',
    'account-item-pay',
    'account-item-actions',
];

$urlParts = currentRelativeURL(false, true, true);

if ($urlParts[0] !== 'account') {
    abort();
}

$current_page_type = $urlParts[1];

if (! $current_page_type) {
    $page_slug = 'account-dashboard';
}

$current_page_type = 'account-' . $current_page_type;

if (not_empty($urlParts[2]) && not_empty($urlParts[3])) {
    $current_page_type = 'account-' . $urlParts[1]. '-' .$urlParts[3];
    $page_parameter = $urlParts[2];
}

if (empty($page_slug) && in_array($current_page_type, $page_types)) {
    $page_slug = $current_page_type;
}

include 'includes/core/check_auth.php';

if (isDemoMode() && ! currentUser()->isCommonUser()) {
    redirect(demoRestrictUrl());
}

/** @var App\Page $current_page */
if (! $current_page) {
    abort();
}

include "{$current_page->getOptions()->controller}";

if ($current_page->isProcessPage()) {
    exit();
}

if (isset($ajax_response)) {
    return $ajax_response;
}

?>

<?php include 'includes/core/head.php' ?>

<?php include 'includes/theme/header.php' ?>

<?php include "{$current_page->getOptions()->content}" ?>

<?php include 'includes/theme/footer.php' ?>