-- MySQL dump 10.13  Distrib 8.0.37, for Linux (x86_64)
--
-- Host: localhost    Database: amlakzan_54gbfdhfdh
-- ------------------------------------------------------
-- Server version	8.0.37

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `amlakzan_54gbfdhfdh`
--


--
-- Table structure for table `tbl_ads`
--

DROP TABLE IF EXISTS `tbl_ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ads` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ADS_TITLE` varchar(255) NOT NULL,
  `ADS_SLUG` varchar(255) NOT NULL,
  `ADS_DESCRIPTION` text NOT NULL,
  `ADS_KEYWORDS` text,
  `ADS_OWNER_NAME` varchar(255) DEFAULT NULL,
  `ADS_OWNER_EMAIL` varchar(255) DEFAULT NULL,
  `ADS_OWNER_PHONE` varchar(20) DEFAULT NULL,
  `ADS_OWNER_ADDRESS` text,
  `ADS_PRICE` varchar(20) DEFAULT NULL,
  `ADS_LINK` varchar(100) DEFAULT NULL,
  `ADS_DISCOUNT` int DEFAULT NULL,
  `CATEGORY_ID` int NOT NULL,
  `STATE_ID` int DEFAULT NULL,
  `CITY_ID` int DEFAULT NULL,
  `LONGITUDE` varchar(100) DEFAULT NULL,
  `LATITUDE` varchar(100) DEFAULT NULL,
  `DATE_CREATED` datetime NOT NULL,
  `DATE_UPDATED` datetime DEFAULT NULL,
  `USER_ID` int NOT NULL,
  `IS_ACTIVE` tinyint NOT NULL DEFAULT '1',
  `VIEWS` int DEFAULT '0',
  `IS_DELETED` smallint NOT NULL DEFAULT '1',
  `IS_EDITED` smallint NOT NULL DEFAULT '1',
  `REJECTION_CAUSE` longtext,
  `IP` varchar(100) DEFAULT NULL,
  `TELEGRAMED` tinyint(1) NOT NULL DEFAULT '0',
  `SHOW_MAP` tinyint(1) NOT NULL DEFAULT '1',
  `featured_image_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IS_ACTIVE` (`IS_ACTIVE`),
  KEY `CATEGORY_ID` (`CATEGORY_ID`),
  KEY `DATE_CREATED` (`DATE_CREATED`),
  KEY `IS_DELETED` (`IS_DELETED`),
  KEY `USER_ID` (`USER_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_ads_info`
--

DROP TABLE IF EXISTS `tbl_ads_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ads_info` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ads_id` int NOT NULL,
  `field_id` int NOT NULL,
  `info_value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_affiliates`
--

DROP TABLE IF EXISTS `tbl_affiliates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_affiliates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `price` int NOT NULL,
  `commision` int NOT NULL,
  `date_created` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '1',
  `comment` varchar(255) DEFAULT NULL,
  `payment_id` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_auth_tokens`
--

DROP TABLE IF EXISTS `tbl_auth_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_auth_tokens` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `selector` char(12) NOT NULL,
  `token` varchar(255) NOT NULL,
  `user_id` int unsigned NOT NULL,
  `type` enum('remember','forgot','activation') NOT NULL DEFAULT 'remember',
  `data` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_backups`
--

DROP TABLE IF EXISTS `tbl_backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_backups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_banners`
--

DROP TABLE IF EXISTS `tbl_banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_banners` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BANNER_DESC` varchar(255) DEFAULT NULL,
  `BANNER_IMAGE` varchar(255) DEFAULT NULL,
  `BANNER_LINK` varchar(255) DEFAULT NULL,
  `WIDTH` int DEFAULT '1200',
  `HEIGHT` int DEFAULT '80',
  `POSITION` varchar(100) DEFAULT 'CONTENT',
  `CATEGORY_ID` int DEFAULT '0',
  `SUBCATEGORY_ID` int DEFAULT '0',
  `SUBSIDIARY_ID` int DEFAULT '0',
  `DATE_CREATED` datetime DEFAULT NULL,
  `WILL_EXPIRE` tinyint(1) NOT NULL DEFAULT '0',
  `STARTS_AT` datetime NOT NULL,
  `EXPIRES_AT` datetime NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_callouts`
--

DROP TABLE IF EXISTS `tbl_callouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_callouts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `callout_id` int NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_categories`
--

DROP TABLE IF EXISTS `tbl_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_categories` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CATEGORY_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `CATEGORY_SLUG` varchar(255) NOT NULL,
  `COLOR` varchar(20) DEFAULT NULL,
  `ICON` varchar(50) DEFAULT NULL,
  `ICON_APP` varchar(50) DEFAULT NULL,
  `image` text,
  `rang` smallint NOT NULL,
  `parent_id` smallint NOT NULL DEFAULT '0',
  `PARENT` varchar(1) DEFAULT NULL,
  `CATEGORY_DESCRIPTION` text,
  `CATEGORY_KEYWORDS` text,
  `CATEGORY_EXTRA_DESCRIPTION` text,
  `enable` tinyint(1) NOT NULL DEFAULT '1',
  `CATEGORY_SEO_TITLE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_cities`
--

DROP TABLE IF EXISTS `tbl_cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cities` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CITY_NAME` varchar(255) NOT NULL,
  `SLUG` varchar(255) DEFAULT NULL,
  `STATE_ID` int NOT NULL,
  `latitude` varchar(200) DEFAULT NULL,
  `longitude` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1451 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_color_palettes`
--

DROP TABLE IF EXISTS `tbl_color_palettes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_color_palettes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_comments`
--

DROP TABLE IF EXISTS `tbl_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_comments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT 'ads',
  `post_id` int NOT NULL,
  `user_id` int NOT NULL,
  `text` text NOT NULL,
  `parent_id` int NOT NULL DEFAULT '0',
  `status` smallint NOT NULL DEFAULT '0' COMMENT '0:not_accepted;1:rejected;2:accepted;3:spam',
  `created_at` datetime NOT NULL,
  `ip` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_coupons`
--

DROP TABLE IF EXISTS `tbl_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_coupons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `type` varchar(100) NOT NULL,
  `discount` varchar(255) DEFAULT NULL,
  `description` text,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_custom_field_options`
--

DROP TABLE IF EXISTS `tbl_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_custom_field_options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `custom_field_id` int NOT NULL,
  `option_key` varchar(255) NOT NULL,
  `option_value` varchar(255) DEFAULT NULL,
  `selected` smallint NOT NULL DEFAULT '0',
  `sort` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  CONSTRAINT `tbl_custom_field_options_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `tbl_custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=260 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_custom_fields`
--

DROP TABLE IF EXISTS `tbl_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_custom_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int NOT NULL,
  `subcategory_id` int NOT NULL,
  `type` varchar(100) DEFAULT NULL,
  `field_type` varchar(50) DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `field_value` text,
  `title` varchar(255) DEFAULT NULL,
  `placeholder` varchar(255) DEFAULT NULL,
  `class` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_required` smallint NOT NULL DEFAULT '0',
  `input_icon` varchar(200) DEFAULT NULL,
  `sort` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_favourites`
--

DROP TABLE IF EXISTS `tbl_favourites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_favourites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ads_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_general_settings`
--

DROP TABLE IF EXISTS `tbl_general_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_general_settings` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SETTING` varchar(255) NOT NULL,
  `VALUE` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_help`
--

DROP TABLE IF EXISTS `tbl_help`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_help` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PAGE_SLUG` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `CONTENT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `PAGE_SLUG` (`PAGE_SLUG`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf32;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_images`
--

DROP TABLE IF EXISTS `tbl_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_images` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `link_id` bigint NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `path` text,
  `alt` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_likes`
--

DROP TABLE IF EXISTS `tbl_likes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_likes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `link_id` int NOT NULL,
  `type` varchar(10) NOT NULL,
  `like` int NOT NULL DEFAULT '0',
  `dislike` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_links`
--

DROP TABLE IF EXISTS `tbl_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_links` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `LINK_TITLE` varchar(255) DEFAULT NULL,
  `LINK_ADDRESS` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_mail_box`
--

DROP TABLE IF EXISTS `tbl_mail_box`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_mail_box` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int DEFAULT NULL,
  `TITLE` text,
  `SENDER_NAME` varchar(150) DEFAULT NULL,
  `SENDER_MAIL` varchar(150) DEFAULT NULL,
  `RECIVER_MAIL` text,
  `RECIVER_USER_ID` varchar(150) DEFAULT NULL,
  `FROM` enum('ADMIN','USER','AUTO') NOT NULL DEFAULT 'ADMIN',
  `TO` enum('ADMIN','USER') NOT NULL DEFAULT 'USER',
  `REPLY_TO` int DEFAULT NULL,
  `MESSAGE` text,
  `RES_ID` text,
  `DATE_CREATED` datetime NOT NULL,
  `USERS_VIEWED` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_menus`
--

DROP TABLE IF EXISTS `tbl_menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_menus` (
  `id` int NOT NULL AUTO_INCREMENT,
  `rang` int NOT NULL,
  `parent_id` int NOT NULL,
  `name` varchar(256) NOT NULL,
  `deletable` enum('YES','NO') DEFAULT 'NO',
  `page_id` int DEFAULT NULL,
  `url_link` varchar(255) DEFAULT NULL,
  `is_external` smallint NOT NULL DEFAULT '1',
  `url_target` varchar(20) DEFAULT '_self',
  `module_code` varchar(100) DEFAULT NULL,
  `icon` varchar(60) DEFAULT NULL,
  `description` varchar(256) DEFAULT NULL,
  `type` enum('ADMIN','USER') DEFAULT 'USER',
  `page_route` varchar(255) DEFAULT NULL,
  `status` smallint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_modules`
--

DROP TABLE IF EXISTS `tbl_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_modules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `module_code` varchar(255) NOT NULL,
  `module_name` varchar(255) NOT NULL,
  `hide` smallint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_notifications`
--

DROP TABLE IF EXISTS `tbl_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_notifications` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `notifiable` varchar(255) NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_order_item_metas`
--

DROP TABLE IF EXISTS `tbl_order_item_metas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_order_item_metas` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`id`),
  KEY `order_item_id` (`order_item_id`),
  CONSTRAINT `tbl_order_item_metas_ibfk_1` FOREIGN KEY (`order_item_id`) REFERENCES `tbl_order_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_order_items`
--

DROP TABLE IF EXISTS `tbl_order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_order_items` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `order_id` bigint NOT NULL,
  `name` text NOT NULL,
  `type` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  CONSTRAINT `tbl_order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `tbl_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_orders`
--

DROP TABLE IF EXISTS `tbl_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_orders` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reversal_request` int DEFAULT NULL COMMENT '999:connection err',
  `user_id` int NOT NULL,
  `ads_id` int NOT NULL,
  `new_plan_id` int NOT NULL DEFAULT '0',
  `nature` varchar(255) DEFAULT 'add-new',
  `period` int NOT NULL DEFAULT '1',
  `price` int NOT NULL,
  `res_code` int DEFAULT NULL,
  `sale_order_id` varchar(50) DEFAULT NULL,
  `sale_refrence_id` varchar(50) DEFAULT NULL,
  `ref_id` varchar(50) DEFAULT NULL,
  `done` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1=false;2=true',
  `setteled` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1:false;2:true',
  `kind` varchar(50) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `comment` varchar(100) DEFAULT NULL,
  `seen` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_page_widgets`
--

DROP TABLE IF EXISTS `tbl_page_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_page_widgets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `UUID` varchar(255) NOT NULL,
  `page_id` int NOT NULL,
  `widget` varchar(255) NOT NULL,
  `options` longtext,
  `sort` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=438 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_pages`
--

DROP TABLE IF EXISTS `tbl_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_pages` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(255) NOT NULL,
  `SLUG` varchar(100) NOT NULL,
  `BODY` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `DATE_CREATED` datetime NOT NULL,
  `IS_CONTACT` tinyint(1) NOT NULL DEFAULT '1',
  `IS_ACTIVE` tinyint(1) NOT NULL DEFAULT '2',
  `META_KEYWORDS` text,
  `META_DESCRIPTION` text,
  `DEFAULT_TITLE` varchar(255) DEFAULT NULL,
  `META_TITLE` varchar(255) DEFAULT NULL,
  `IS_DELETABLE` tinyint(1) NOT NULL DEFAULT '1',
  `EDIT_TITLE` tinyint(1) NOT NULL DEFAULT '1',
  `EDIT_SLUG` tinyint(1) NOT NULL DEFAULT '1',
  `EDIT_BODY` tinyint(1) NOT NULL DEFAULT '1',
  `SITEMAP` tinyint(1) NOT NULL DEFAULT '1',
  `is_admin` tinyint(1) NOT NULL DEFAULT '0',
  `parent_id` int NOT NULL DEFAULT '0',
  `route` varchar(255) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `options` text,
  `settings` longtext,
  `has_menu` tinyint(1) NOT NULL DEFAULT '1',
  `is_public` smallint DEFAULT '2',
  `is_editable` smallint NOT NULL DEFAULT '2',
  `has_widget_area` smallint NOT NULL DEFAULT '1',
  `edit_seo_fields` smallint NOT NULL DEFAULT '2',
  PRIMARY KEY (`ID`,`SLUG`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_plans`
--

DROP TABLE IF EXISTS `tbl_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_plans` (
  `ID` smallint NOT NULL AUTO_INCREMENT,
  `PLAN_TITLE` varchar(255) NOT NULL,
  `PLAN_DAYS` bigint DEFAULT NULL,
  `PLAN_PRICE` bigint DEFAULT NULL,
  `PLAN_UPDATE_TIMES` mediumint NOT NULL DEFAULT '0',
  `IS_SLIDER` smallint NOT NULL DEFAULT '1',
  `IS_SIDE_SLIDER` tinyint NOT NULL DEFAULT '1',
  `IS_TEXT` tinyint NOT NULL DEFAULT '1',
  `IS_FREE` smallint NOT NULL DEFAULT '1',
  `HAS_LINK` tinyint NOT NULL DEFAULT '1',
  `MAX_IMG_COUNT` tinyint NOT NULL DEFAULT '3',
  `MAX_KEYWORD_COUNT` tinyint NOT NULL DEFAULT '5',
  `MAX_EDIT_COUNT` tinyint NOT NULL DEFAULT '1',
  `PLAN_PRIORITY` int DEFAULT NULL,
  `PLAN_STARS` int NOT NULL DEFAULT '0',
  `HAS_TELEGRAM` smallint NOT NULL DEFAULT '1',
  `DISCOUNT_FOR_3_PERIOD` smallint NOT NULL DEFAULT '0',
  `DISCOUNT_FOR_6_PERIOD` smallint NOT NULL DEFAULT '0',
  `DISCOUNT_FOR_12_PERIOD` smallint NOT NULL DEFAULT '0',
  `IS_DELETABLE` smallint NOT NULL DEFAULT '1',
  `IS_ENABLE` smallint NOT NULL DEFAULT '1',
  `COLOR` varchar(255) DEFAULT '#6DB6FD',
  `RIBBON_TEXT` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_policy_report`
--

DROP TABLE IF EXISTS `tbl_policy_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_policy_report` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `ADS_ID` bigint unsigned NOT NULL,
  `REPORT` text NOT NULL,
  `DATE_CREATED` datetime NOT NULL,
  `USER_ID` int DEFAULT NULL,
  `IP` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ADS_ID` (`ADS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_post_categories`
--

DROP TABLE IF EXISTS `tbl_post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_post_categories` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CATEGORY_NAME` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci DEFAULT NULL,
  `CATEGORY_SLUG` varchar(200) NOT NULL,
  `META_DESCRIPTION` text,
  `META_KEYWORDS` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_posts`
--

DROP TABLE IF EXISTS `tbl_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_posts` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `TITLE` varchar(255) NOT NULL,
  `SLUG` varchar(255) NOT NULL,
  `POST_TEXT` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `CATEGORY_ID` int DEFAULT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_UPDATED` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `IS_ACTIVE` tinyint NOT NULL DEFAULT '2',
  `POST_META_DESCRIPTION` text,
  `POST_META_KEYWORDS` text,
  `TELEGRAMED` tinyint(1) NOT NULL DEFAULT '0',
  `short_description` text,
  `views` bigint NOT NULL DEFAULT '0',
  `featured_image_id` bigint DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_settings`
--

DROP TABLE IF EXISTS `tbl_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_settings` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SETTING` varchar(255) NOT NULL,
  `VALUE` text NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=269 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_sms_box`
--

DROP TABLE IF EXISTS `tbl_sms_box`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_sms_box` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int DEFAULT NULL,
  `TITLE` text,
  `SENDER_NAME` varchar(150) DEFAULT NULL,
  `SENDER_NUMBER` varchar(50) DEFAULT NULL,
  `RECIVER_NUMBER` text,
  `RECIVER_USER_ID` varchar(150) DEFAULT NULL,
  `FROM` enum('ADMIN','USER','AUTO') NOT NULL DEFAULT 'ADMIN',
  `TO` enum('ADMIN','USER') NOT NULL DEFAULT 'USER',
  `REPLY_TO` int DEFAULT NULL,
  `MESSAGE` text,
  `RES_ID` text,
  `DATE_CREATED` datetime NOT NULL,
  `USERS_VIEWED` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_specials`
--

DROP TABLE IF EXISTS `tbl_specials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_specials` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `ADS_ID` bigint unsigned NOT NULL,
  `ADS_TYPE` smallint DEFAULT NULL,
  `FROM_DATE` datetime DEFAULT NULL,
  `FROM_UPDATED_DATE` datetime NOT NULL,
  `UPDATE_COUNT` mediumint NOT NULL DEFAULT '0',
  `TO_DATE` datetime DEFAULT NULL,
  `IS_PAID` tinyint DEFAULT '1',
  `IS_SHOWN` tinyint NOT NULL DEFAULT '1',
  `FIRST_EXPIRE_EMAIL` tinyint DEFAULT '1',
  `SECOND_EXPIRE_EMAIL` tinyint DEFAULT '1',
  `THIRD_EXPIRE_EMAIL` tinyint DEFAULT '1',
  `IS_REJECTED` smallint NOT NULL DEFAULT '1',
  `IS_EXPIRED` smallint NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`),
  KEY `IS_SHOWN` (`IS_SHOWN`),
  KEY `ADS_ID` (`ADS_ID`),
  KEY `ADS_TYPE` (`ADS_TYPE`),
  KEY `IS_EXPIRED` (`IS_EXPIRED`),
  CONSTRAINT `tbl_specials_ibfk_1` FOREIGN KEY (`ADS_ID`) REFERENCES `tbl_ads` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_states`
--

DROP TABLE IF EXISTS `tbl_states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_states` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `STATE_NAME` varchar(255) NOT NULL,
  `SLUG` varchar(255) DEFAULT NULL,
  `STATE_ID` int DEFAULT '0',
  `IS_COUNTRY` tinyint(1) NOT NULL DEFAULT '1',
  `latitude` varchar(200) DEFAULT NULL,
  `longitude` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `SLUG` (`SLUG`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_stats`
--

DROP TABLE IF EXISTS `tbl_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_stats` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DATE` varchar(40) NOT NULL,
  `HITS` int NOT NULL,
  `UNIQUE_HITS` int NOT NULL,
  `SHAMSI_DATE` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_subcategories`
--

DROP TABLE IF EXISTS `tbl_subcategories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subcategories` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SUBCATEGORY_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `SUBCATEGORY_SLUG` varchar(255) NOT NULL,
  `CATEGORY_ID` int NOT NULL,
  `PARENT` int DEFAULT '0',
  `SUBCATEGORY_DESCRIPTION` text,
  `SUBCATEGORY_KEYWORDS` text,
  `SUBCATEGORY_EXTRA_DESCRIPTION` text,
  `ICON` varchar(50) DEFAULT NULL,
  `ICON_APP` varchar(50) DEFAULT NULL,
  `image` text,
  `COLOR` varchar(20) DEFAULT NULL,
  `rang` int NOT NULL DEFAULT '0',
  `enable` tinyint(1) NOT NULL DEFAULT '1',
  `SUBCATEGORY_SEO_TITLE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `CATEGORY_ID` (`CATEGORY_ID`),
  KEY `SUBCATEGORY_SLUG` (`SUBCATEGORY_SLUG`)
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_tags`
--

DROP TABLE IF EXISTS `tbl_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_tags` (
  `TAG_ID` int NOT NULL AUTO_INCREMENT,
  `TAG_NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `TAG_SLUG` varchar(100) NOT NULL,
  PRIMARY KEY (`TAG_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_tags_relation`
--

DROP TABLE IF EXISTS `tbl_tags_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_tags_relation` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `LINK_ID` int NOT NULL,
  `TAG_ID` int NOT NULL,
  `TYPE` varchar(50) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `TAG_ID` (`TAG_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_telegram_box`
--

DROP TABLE IF EXISTS `tbl_telegram_box`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_telegram_box` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message_id` int NOT NULL,
  `post_id` int NOT NULL,
  `type` enum('ads','post') NOT NULL DEFAULT 'ads',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_user_levels`
--

DROP TABLE IF EXISTS `tbl_user_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_levels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `rule_code` varchar(255) NOT NULL,
  `rule_name` varchar(255) NOT NULL,
  `access_levels` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_user_metas`
--

DROP TABLE IF EXISTS `tbl_user_metas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_metas` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `meta_value` text,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `tbl_user_metas_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_users`
--

DROP TABLE IF EXISTS `tbl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_users` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `NAME` varchar(100) DEFAULT NULL,
  `LAST_NAME` varchar(250) DEFAULT NULL,
  `TEL` varchar(12) DEFAULT NULL,
  `EMAIL` varchar(60) DEFAULT NULL,
  `ADDRESS` text,
  `CREDIT_CARD` varchar(225) DEFAULT NULL,
  `USER_LEVEL` varchar(50) NOT NULL DEFAULT 'USER',
  `USERNAME` varchar(100) NOT NULL,
  `PASSWORD` varchar(32) NOT NULL,
  `IS_ACTIVE` enum('1','2','3') NOT NULL DEFAULT '1',
  `REFERER_ID` varchar(100) DEFAULT NULL,
  `BIOGRAPHY` text,
  `WEBSITE` varchar(100) DEFAULT NULL,
  `USER_DATE_CREATED` datetime DEFAULT NULL,
  `FREE_ADS_COUNT` smallint NOT NULL DEFAULT '0',
  `PHONE` varchar(255) DEFAULT NULL,
  `VERIFIED_EMAIL` varchar(60) DEFAULT NULL,
  `VERIFIED_MOBILE` varchar(12) DEFAULT NULL,
  `profile_views` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `USERNAME` (`USERNAME`),
  UNIQUE KEY `user_uuid` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_withdrawal_requests`
--

DROP TABLE IF EXISTS `tbl_withdrawal_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_withdrawal_requests` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `price` int NOT NULL,
  `referal_ids` text NOT NULL,
  `date_created` datetime NOT NULL,
  `status` int NOT NULL COMMENT '1:suspended;2:settled',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping events for database 'amlakzan_54gbfdhfdh'
--

--
-- Dumping routines for database 'amlakzan_54gbfdhfdh'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-04-09 19:45:53
