<?php
require_once(__DIR__ . '/../vendor/autoload.php');

session_start();
ob_start();

use App\KoDesign\Config;
use App\KoDesign\Cookie;
use App\KoDesign\Cryptor;
use App\KoDesign\Pagination;
use App\Models\Setting;
use Carbon\Carbon;
use Dotenv\Dotenv;
use Illuminate\Container\Container;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Cache\CacheManager;
use Illuminate\Database\Capsule\Manager as Capsule;

$dotenv = Dotenv::createUnsafeImmutable(__DIR__ . '/../');
$dotenv->load();

date_default_timezone_set("Asia/Tehran");
ini_set('display_errors', 0);


/*-----------------
| Define Constants
------------------*/
defined('DS')        ? null : define('DS', DIRECTORY_SEPARATOR);
defined('BASE_PATH') ? null : define('BASE_PATH', dirname(__FILE__) . DS . '..' . DS);
defined('PUBLIC_URL')  ? null : define('PUBLIC_URL', getenv('ROOT_URL'));

defined('SITE_PATH')                ? null : define('SITE_PATH',                BASE_PATH . '..' . DS . 'public_html' . DS);
defined('PUBLIC_PATH')              ? null : define('PUBLIC_PATH',              SITE_PATH . 'api' . DS);
defined('IMAGES_BASE_PATH')         ? null : define('IMAGES_BASE_PATH',         SITE_PATH . 'images' . DS);
defined('IMAGES_PATH')              ? null : define('IMAGES_PATH',              IMAGES_BASE_PATH . 'estate_images' . DS);
defined('IMAGES_POST_PATH')         ? null : define('IMAGES_POST_PATH',         IMAGES_BASE_PATH . 'post_images' . DS);
defined('CATEGORY_IMAGES_PATH')     ? null : define('CATEGORY_IMAGES_PATH',     IMAGES_BASE_PATH . 'categories' . DS);
defined('IMAGES_TEMP_PATH')         ? null : define('IMAGES_TEMP_PATH',         IMAGES_PATH . 'app_temp' . DS);


include(BASE_PATH . 'bootstrap/config.php');

/*---------------------------
| Instantiate the Container
----------------------------*/
$app = new Container();


/*--------------------------------------
| Instantiate Public Filesystem Wrapper
---------------------------------------*/
$app->singleton('files', function () {
    return new Filesystem();
});


/*----------------------------------------
| Instantiate the cache manager
------------------------------------------*/
$app->singleton('config', function () {
    return [
        'cache.default' => 'files',
        'cache.stores.files' => [
            'driver' => 'file',
            'path' => cache_path(),
        ]
    ];
});

$cacheManager = new CacheManager($app);
$cache = $cacheManager->driver();

$app->singleton('cache', function () use ($cache) {
    return $cache;
});

/*----------------------------------------
| Instantiate the settings
------------------------------------------*/
$app->singleton('setting', function () {
    return new Setting();
});

/*----------------------------------------
| Instantiate the settings
------------------------------------------*/
$app->singleton('config', function () {
    return new Config();
});

/*----------------------------------------
| Instantiate the Pagination
------------------------------------------*/
$app->singleton('pagination', function () {
    return new Pagination();
});

/*--------------------------------
| Instantiate Error Handling Class
----------------------------------*/
//  $whoops = new \Whoops\Run;
//  $whoops->pushHandler(new \Whoops\Handler\PrettyPageHandler);
//  $whoops->register();

/*-------------------------
| Instantiate Database Class
---------------------------*/
$capsule = new Capsule();
$capsule->addConnection([
    'driver' => getenv('DB_DRIVER'),
    'host' => getenv('DB_HOST'),
    'database' => getenv('DB_NAME'),
    'username' => getenv('DB_USER'),
    'password' => getenv('DB_PASS'),
    'charset' => 'utf8',
    'collation' => 'utf8_general_ci',
    'prefix' => 'tbl_'
]);

$capsule->setAsGlobal();
$capsule->bootEloquent();

/*-------------------------
| Instantiate Routing Class
---------------------------*/
$router = new AltoRouter();
$router->setBasePath(PUBLIC_URL);

/*-------------------------
| Instantiate Crypt Class
---------------------------*/
$app->singleton('encryption', function () {
    return new Cryptor();
});

/*-------------------------
| Instantiate Cookie Class
---------------------------*/
$app->singleton('cookie', function () {
    return new Cookie();
});

/*--------------------------------
| Set Locale for Carbon Instance
----------------------------------*/
Carbon::setLocale(getenv('LOCALE'));

settings()->clearCache();
