<?php
use App\KoDesign\BladeWrapper;

/**
 * Returns the path to before root folder (base path)
 *
 * @return string
 */
function base_path() {
    return BASE_PATH;
}

/**
 * Returns the path to before root folder (base path)
 *
 * @return string
 */
function views_path() {
    return base_path() . "views";
}

/* -----------------------------------------
|           Cache Helpers
-------------------------------------------*/

/**
 * returns the path of cache folder
 *
 * @param string $type
 * @return string
 */
function cache_path($type = 'files')
{
    $root = BASE_PATH . getenv('CACHE_FOLDER') . DS;

    switch ($type) {
        case 'files' :
            $root .= 'files' . DS;
            break;
        case 'views' :
            $root .= 'views' . DS;
            break;
    }

    return $root;
}

/**
 * Returns the instance of cache stored in app container
 *
 * @return mixed
 */
function cache()
{
    global $app;

    return $app['cache'];
}

/* -----------------------------------------
|           Settings Helpers
-------------------------------------------*/

/**
 * Returns the instance of settings stored in app container
 *
 * @return mixed
 */
function settings()
{
    global $app;

    return $app['setting'];
}

function makeHash($algorithem, $string) {
    return hash($algorithem, $string);
}

/* -----------------------------------------
|           FileSystem Helpers
-------------------------------------------*/

/**
 * Returns the instance of filesystem stored in app container
 *
 * @return mixed
 */
function filesystem()
{
    global $app;

    return $app['files'];
}

/* -----------------------------------------
|           Encryption Helpers
-------------------------------------------*/

/**
 * Returns the instance of filesystem stored in app container
 *
 * @return mixed
 */
function cryptor()
{
    global $app;

    return $app['encryption'];
}

/* -----------------------------------------
|           Cookie Helpers
-------------------------------------------*/

/**
 * Returns the instance of Cookie Class stored in app container
 *
 * @return mixed
 */
function cookie()
{
    global $app;

    return $app['cookie'];
}

/* -----------------------------------------
|           Config Helpers
-------------------------------------------*/

/**
 * Returns the Instance of Config Class Stored in app container
 *
 * @param string|null $config :: if not null, will return the given config value via Config::get() method
 * @return mixed
 */
function config($config = null)
{
    global $app;

    if (!empty($config)) {
        return $app['config']->get($config);
    }

    return $app['config'];
}

/* -----------------------------------------
|           Stat Helpers
-------------------------------------------*/
function stats()
{
    global $app;

    return $app['stats'];
}

/**
 * Returns a quick instance of bladeWrapper Class
 *
 * @return BladeWrapper
 */
function blade() {
    return new BladeWrapper();
}