<?php

namespace App\KoDesign\Sms;

class Unique
{

    protected $api_key;
    protected $secret_key;
    protected $api_url;
    protected $_from;

    /**
     * Gets config parameters for sending request.
     *
     * @param $api_key
     * @param $secret_key
     * @param $api_url
     */
    // @ioncube.dk makeHash("whirlpool", "23476bf2fd3134702e6c8ecaedd598c43911cfebfce4574f39299a737123637b") -> "efd37db871b7931914faecaa714893fa1f6bfa2fcb7b2518c760fad77a36ece98f9191942d0a3c2ff90ed9b221b8a8399e2b16a385bfbb7a4c2e32c46ee0be6e" RANDOM
    public function __construct($api_key, $secret_key, $api_url)
    {
        $this->api_key = $api_key;
        $this->secret_key = $secret_key;
        $this->api_url = $api_url;
        $this->_from = setting('SITE_SMS_NUMBER');
    }

    /**
     * Sends SMS with service Number
     *
     * @param $to
     * @param $variables
     * @param $template_id
     * @return bool|string
     */
    // @ioncube.dk makeHash("md4", "a6916ee02509db3a4e0a2b2742c14ccec2cc6979b3463dd7f75c41667d7bbca6") -> "797011c7e022021967264b00e05a043d" RANDOM
    public function send($to, $variables, $template_id)
    {
        try {
            $unique_data = $this->analyzeParameters($to, $variables, $template_id);

            return $this->ultraFastSend($unique_data);
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * Ultra Fast Send Message.
     *
     * @param array $data array structure of message data
     *
     * @return string Indicates the sent sms result
     */
    // @ioncube.dk makeHash("md5", "8697e15982be17b287eddbf34126035a41eda9af40f723fdff2b51a782cfebf123cf2d1e9fd7b3bafbf1c21051e210a940a2613c0c83288c9698e77a624dc119") -> "ae4a2cdf1bc92eb199e45fa2de3d350c" RANDOM
    protected function ultraFastSend($data)
    {
        $ch = new MyCurl($data);

        $ch->createCurl();

        return $ch->getCurlResault();
    }

    /**
     * Gets token key for all web service requests.
     *
     * @return string Indicates the token key
     */
    // @ioncube.dk makeHash("sha384", "9c5ee82848659fee0394a66f6a0f40962094b2f65ef5340b7d8001a02c15e56c") -> "a93c3fdee5577cc00050660d420532da0df2ae4a5f434e4c512ae58a0060db6e0656c4f45bb3c1626f52535687c91e46" RANDOM
    private function _getToken()

    {
        $postData = array(
            'UserApiKey' => $this->api_key,
            'SecretKey' => $this->secret_key,
            'System' => 'php_rest_v_2_0'
        );
        $postString = json_encode($postData);

        $ch = curl_init($this->api_url . $this->getApiTokenUrl());
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json'
            )
        );
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);
        //        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Request Error:' . curl_error($ch);
        }
        curl_close($ch);

        $response = json_decode($result);

        $resp = false;

        if (is_object($response)) {
            $IsSuccessful = $response->IsSuccessful;
            if ($IsSuccessful == true) {

                $TokenKey = $response->TokenKey;
                $resp = $TokenKey;
            } else {
                $resp = false;
            }
        }
        return $resp;
    }

    /**
     * Executes the main method.
     *
     * @param array $postData array of json data
     * @param string     $url      url
     * @param string     $token    token string
     *
     * @return string Indicates the curl execute result
     */
    // @ioncube.dk makeHash("md4", "379db2d31f467b52e9890d952828aad6bb367881421ef315a1366e105679e969f23ac3471b99e6e4737d47602b5182eb3ffdc6d6ce9d4b950bcb507d3353b607") -> "ba6d6080bafdba69c879705666431ea1" RANDOM
    private function _execute($postData, $url, $token)
    {
        $postString = json_encode($postData);

        $ch = curl_init($url);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'x-sms-ir-secure-token: ' . $token
            )
        );
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);

        $result = curl_exec($ch);
        curl_close($ch);

        return $result;
    }

    /**
     * Gets API Ultra Fast Send Url.
     *
     * @return string Indicates the Url
     */
    // @ioncube.dk makeHash("md4", "be8267337dbbca099fe30ec74166910aadfc2055f36163b1b266667f269dfabe010933889dc2e91ca0d9503162d9b33cc42359d2f262265c121bd87b2ce5b65b") -> "099a478b22d832e84e1f18ca94be05b7" RANDOM
    protected function getAPIUltraFastSendUrl()
    {
        return "api/UltraFastSend";
    }

    /**
     * Gets Api Token Url.
     *
     * @return string Indicates the Url
     */
    // @ioncube.dk makeHash("gost-crypto", "ad0c08621a42d2b26bc7d7464c18830431aba773644720a83ef71a0cf86a9a7e") -> "b50b7f103a727644b31fc6f49e3f32f001fc087bd2e5322e7b83fee7ffd696ff" RANDOM
    protected function getApiTokenUrl()
    {
        return "api/Token";
    }


    /**
     * returns the data array needed for sending unique sms
     *
     * @param $to
     * @param $variables
     * @param $template_id
     * @return array
     */
    // @ioncube.dk makeHash("ripemd128", "9b40e86c7455588ce0e314103aa1750f") -> "ce1b7971297e092c4bbca447130dbfc0" RANDOM
    protected function analyzeParameters($to, $variables, $template_id)
    {
        unset($variables['siteName']);
        unset($variables['password']);

        $post = [
            'code' => $template_id,
            'sender' => $this->_from,
            'recipient' => $to,
            'variable' => $variables
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://api2.ippanel.com/api/v1/sms/pattern/normal/send');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post));

        $headers = array();
        $headers[] = 'Accept: */*';
        $headers[] = 'Apikey: ' . $this->api_key;
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        curl_close($ch);

        $res = json_decode($result);
        return $res->status;
    }
}
