<?php
namespace App\KoDesign\Sms;

use App\KoDesign\CustomCurl;

class Rest {
    protected $_from;
    protected $_username;
    protected $_password;
    protected $_APISendUrl;
    protected $_APIDeliveryUrl;
    protected $_APICreditUrl;
    protected $_to;
    protected $_text;
    protected $_sendUrl;
    protected $_deliveryUrl;
    protected $_creditUrl;
    protected $_resId;
    protected $_deliveryStatus;
    protected $_deliveryStatusParams;


    public function __construct()
    {
        $this->_from 			= setting('SITE_SMS_NUMBER');
        $this->_username 		= setting('SMS_USERNAME');
        $this->_password 		= setting('SMS_PASSWORD');
        $this->_APISendUrl 		= setting('SMS_SEND_URL');
        $this->_APIDeliveryUrl 	= setting('SMS_DELIVERY_URL');
        $this->_APICreditUrl 	= setting('SMS_CREDIT_URL');
        $this->_deliveryStatusParams = [];
    }

    public function set_to($number=''){
        $this->_to=$number;
    }

    public function set_text($text=''){
        $this->_text = urlencode($text);
    }

    public function Send()
    {
        $this->setSendUrl();

        $ch = new CustomCurl($this->_sendUrl);
        $ch->createCurl();
        return $this->_resId = $ch->getCurlResault();
    }

    public function DeliveryStatus($resId = 'nul')
    {
        if($resId == 'nul'){
            $resId = $this->_resId;
        }

        $this->getDelivery($resId);

        if( array_key_exists($this->_deliveryStatus,$this->_deliveryStatusParams) ) {
            return $this->_deliveryStatusParams[$this->_deliveryStatus];
        }

        return false;
    }

    public function getCredit()
    {
        $this->setCreditUrl();

        $ch=new CustomCurl($this->_creditUrl);
        $ch->createCurl();
        return $ch->getCurlResault();
    }

    protected function setSendUrl()
    {
        $this->_sendUrl = $this->_APISendUrl."?username=" . $this->_username . "&password=" . $this->_password . "&from=" . $this->_from . "&to=" . $this->_to . "&text=" . $this->_text . "";

    }

    protected function setDeliveryUrl($resId = 'nul')
    {
        $this->_deliveryUrl=$this->_APIDeliveryUrl."?resId=" . $this->_resId . "";
    }

    protected function setCreditUrl()
    {
        $this->_creditUrl=$this->_APICreditUrl."?username=" . $this->_username . "&password=" . $this->_password . "" ;
    }

    protected function getDelivery($resId)
    {
        $this->setDeliveryUrl($resId);

        $ch = new CustomCurl($this->_deliveryUrl);
        $ch->createCurl();
        $this->_deliveryStatus=$ch->getCurlResault();
    }
}