<?php
namespace App\KoDesign;

class Session
{
	/**
	 * Checks whether a session exists or not
	 *
	 * @param $name
	 * @return bool
     */
	public static function exists($name)
	{
		return (isset($_SESSION[$name])) ? true : false;
	}

	/**
	 * Assign a value to specified session
	 *
	 * @param $name
	 * @param $value
	 * @return mixed
     */
	public static function put($name, $value){
		return $_SESSION[$name] = $value;
	}

	/**
	 * Returns the value of a session
	 *
	 * @param $name
	 * @return mixed
     */
	public static function get($name){
		return (self::exists($name)) ? $_SESSION[$name] : false;
	}

	/**
	 * Checks whether a session is empty or not
	 *
	 * @param $name
	 * @return bool
     */
	public static function not_empty($name){
		$session = self::get($name);
		if(self::exists($name) && !empty($session) && trim($session) !== "")
			return  true;
		
		return false;
	}

	/**
	 * Delete and unset a specified session
	 *
	 * @param $name
     */
	public static function delete($name){
		if(self::exists($name)){
			unset($_SESSION[$name]);
		}
	}

	/**
	 * Delete All the registered data in session array
     */
	public static function deleteAll()
	{
		$_SESSION = array();

		if (ini_get("session.use_cookies")) {
			$params = session_get_cookie_params();
			setcookie(session_name(), '', time() - 42000,
				$params["path"], $params["domain"],
				$params["secure"], $params["httponly"]
			);
		}

		session_destroy();
	}

}
