<?php
namespace App\KoDesign;

class Input
{
	/**
	 * Checks whether a post or get request is exists or not
	 *
	 * @param string $type
	 * @return bool
	 */
	public static function exists($type='post'){
		switch ($type){
			case 'post' :
				return !empty($_POST) ? true : false;
				break;
			case 'get' :
				return !empty($_GET)  ? true : false;
				break;
			default:
				return false;
				break;
		}
	}


	/**
	 * Returns the value of a specific input
	 *
	 * @param $item
	 * @return string
	 */
	public static function get($item)
	{
		if(isset($_POST[$item])){
			return $_POST[$item];
		}else if (isset($_GET[$item])){
			return $_GET[$item];
		}

		return '';
	}

	/**
	 * Checks whether a specified input is exists or not
	 *
	 * @param $item
	 * @return bool
	 */
	public static function is_set($item)
	{
		if(isset($_POST[$item]) || isset($_GET[$item]))
			return true;

		return false;
	}

	/**
	 * Checks whether a specified input is empty or not
	 *
	 * @param $item
	 * @return bool
	 */
	public static function not_empty($item)
	{
		$input = self::get($item);

		if(self::is_set($item) && !empty($input) && trim($input) !== "")
			return  true;

		return false;
	}

	/**
	 * Casts all members of a specific kind of request into an associative array and returns it
	 *
	 * @param string $type
	 * @return array
	 */
	public static function all($type = null)
	{
		$output = array();

		switch($type)
		{
			case 'post' :
				foreach($_POST as $key => $value){
					$output[$key] = $value;
				}

				break;

			case 'get' :
				foreach($_GET as $key => $value){
					$output[$key] = $value;
				}

				break;

			default :
				foreach($_REQUEST as $key => $value){
					$output[$key] = $value;
				}
		}

		return $output;

	}


	/**
	 * Casts only specified members of specific kind of request into an associative array and returns it
	 *
	 * @param array $data
	 * @param string $type
	 * @return array
	 */
	public static function only($data = array(), $type = null)
	{
		$data = makeArray($data);
		$output = array();

		switch($type)
		{
			case 'get' :
				$source = $_GET;
				break;

			case 'post' :
				$source = $_POST;
				break;

			default :
				$source = $_REQUEST;
				break;
		}

		foreach($source as $key => $value)
		{
			if(in_array($key, $data)){
				$output[$key] = $value;
			}
		}

		return $output;
	}

	/**
	 * Casts all members of a specific kind of request Except the specified ones into an associative array and returns it
	 *
	 * @param array $data
	 * @param string $type
	 * @return mixed
	 */
	public static function except($data = array(), $type = 'get')
	{
		$data = makeArray($data);

		switch($type)
		{
			case 'get' :
				$output = $_GET;
				break;

			case 'post' :
				$output = $_POST;
				break;

			default :
				$output = $_REQUEST;
				break;
		}

		foreach($data as $key => $value) {
			unset($output[$value]);
		}

		return $output;
	}

	public static function file($item, $data_type = NULL)
	{
		if( ! empty($data_type) ) {
			return $_FILES[$item][$data_type];
		}

		return $_FILES[$item];
	}

}
