<?php

namespace App\Composers;

use duncan3dc\Laravel\BladeInstance;


class Composer
{
    protected $users;

    /**
     * @param BladeInstance $blade
     */
    public static function compose(BladeInstance $blade)
    {
        $Composer = new ViewComposer();
        $composers = $Composer->register();

        foreach($composers as $view_name => $function_name)
        {
            $blade->composer($view_name, function($view) use ($function_name, $Composer)
            {
                $data = $Composer->$function_name();

                foreach ($data as $key => $value)
                {
                    $view->with($key, $value);
                }
            });
        }
    }

}