function initRemoteSelect() {
    $("*[data-remote-load-data]").each(function() {
        var $this = $(this);

        $this.select2({
            language : "fa",
            ajax: {
                url: $this.attr('data-remote-url'),
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        keyword: params.term
                    };
                },
                processResults: function(data) {
                    return {
                        results: data.items
                    };
                },
                cache: true
            },
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            minimumInputLength: 3,
            templateResult: formatRepo,
            templateSelection: formatRepoSelection
        });
    });
}



function formatRepo(repo) {
    if (repo.loading) return repo.text;

    var markup = "<div class='select2-result-repository clearfix'>";

    if(repo.image) {
        markup += "<div class='select2-result-repository__avatar'><img src='" + repo.image + "' /></div>";
        markup += "<div class='select2-result-repository__meta'>";
    }

    markup += "<div class='select2-result-repository__title'>" + repo.title + "</div></div>";

    if (repo.description) {
        markup += "<div class='select2-result-repository__description'>" + repo.description + "</div>";
    }

    if(repo.image) {
        markup += "</div>"; // closing tag for 'select2-result-repository__meta'
    }

    markup += "<div class='select2-result-repository__statistics'>";
    if(repo.meta1) {
        markup += "<div class='select2-result-repository__forks'>" + repo.meta1 + "</div>";
    }
    if(repo.meta2) {
        markup += "<div class='select2-result-repository__stargazers'>" + repo.meta2 + "</div>";
    }
    if(repo.meta3) {
        markup += "<div class='select2-result-repository__watchers'>" + repo.meta3 + "</div>";
    }
    markup += "</div>";

    return markup;
}

function formatRepoSelection(repo) {
    return repo.title || repo.text;
}

initRemoteSelect();